#!/usr/local/bin/perl

sub get_file {
	
	my($filename);
	my($inpath) = $inputpath;
	$inpath     =~ s/$root_path//eg;

	print &html("Import Text File") if $in{'action'} eq "from_text";
	print &html("Import DBase File") if $in{'action'} eq "from_x_base";

	print "$form_method";
	print "<b>IMPORTANT:</b> All files for Import must be FTPed to <b>$inpath.</b><br><br>";
	print "<INPUT TYPE=\"HIDDEN\" NAME=\"action\" VALUE=\"$in{'action'}_final\">";
	print "<table border = 0>\n";
	print "<tr valign=top>\n";
	
	opendir (DUMP_DIR, $inputpath) or print "Unable to open Input directory.";

	while ($filename = readdir(DUMP_DIR)) {
		if (($filename ne ".") && ($filename ne "..")) {
			if (!$found) {
				print "		<td align=right>Select The File to Import</td>\n";
				print "		<td>\n\t<SELECT NAME=\"file\" SIZE=5>\n";
				$found = 1;
			}
			print qq*\t\t<OPTION VALUE="$inputpath/$filename">$filename\n*;
		}
	}	

	if ($found) {
		print "</SELECT>\n";
		print "</td>\n</tr>\n";
		print "<tr nowrap>\n";
		print "<td align=right>New Table Name:</td>\n";
		print "<td><INPUT TYPE = \"TEXT\" NAME = \"new_table_name\" SIZE=\"10\" MAXLENGTH=\"50\"> (This action creates a new table.)";
		print "</td>\n</tr>\n";

		if ($in{'action'} eq "from_text") {
			print "
			<tr valign=top>
				<td align=right>Field Separator:</td>
				<td>
					<SELECT NAME=\"separator\">
						<OPTION VALUE=\"\">** Please Select **
						<OPTION VALUE=\"\|\">\Pipe Character: \|
						<OPTION VALUE=\"tab\">Tab Character
						<OPTION VALUE=\",\">Comma: ,
						<OPTION VALUE=\"other\">Other 
					</SELECT> 
					If Other, please specify: 
					<INPUT TYPE = \"TEXT\" NAME = \"other_separator\" SIZE=\"3\" MAXLENGTH=\"3\">
				</td>
			</tr>
			<tr>
				<td align = right>
					First Row Contains Field Names:
				</td>
				<td>
					<SELECT NAME=\"column_names\">
						<OPTION VALUE=\"1\" SELECTED>Yes
						<OPTION VALUE=\"\">No
					</SELECT>
				</td>
			</tr>";
		} 

		print "\n</table>\n<hr><center><INPUT TYPE=\"submit\" NAME=\"submit\" VALUE=\"Import File\"></center>";

	} else {

		print "<td nowrap><h3>No files found in the Input directory</h3></td></tr>\n</table>";

	}

	print "\n</form>\n";
	print &html_bot;
	closedir (DUMP_DIR);
	return 1;
}

sub to_text {
	
	my($time_val) = time;
	my($separator) = $in{'separator'};
	my($dumpfile, $sth, @arr);
	
	$separator = chr(9) if $separator eq "tab";
	&print_error("Please select the file separator.") if $separator eq "";
	
	&print_error("Please select the \"Other\" file separator.") if $separator eq "other" and $in{'other_separator'} eq "";
	$separator = $in{'other_separator'} if $separator eq "other";

	#if (($separator eq "") || (($separator eq "other") && ($in{'other_separator'} eq ""))) {
	#	&get_separator("Export File");
	#}
	&print_error("Please select the table to Export.") unless $table;
	
	$dumpfile = "$table-$time_val.tb";
    $dumpfile = "$dumppath/$dumpfile";
	open (DUMP_FILE,">>$dumpfile") or &print_error("Can't Open File for export!"); 
	
	if ($in{'column_names'}) {
		$fields =  &field_list($table);
		$fields =~ s/,/$separator/eg;
		print DUMP_FILE "$fields\n";
	}

	$sth = $dbh->Query(&SQLSelect($table)) or &print_error("SELECT Command Failed!");
	while(@arr = $sth->FetchRow) {
		foreach $i (0..$#arr) {
			$temp .= $arr[$i];
			$temp .= $separator unless $i == $#arr;
		}
		print DUMP_FILE "$temp\n";
		$temp="";
	}
	
	close DUMP_FILE;
	
	print &html("Export Table");
	$dumpfile =~ s/$root_path//;
	print "\n</b>Table dumped successfully to $dumpfile<a href = \"$dumpfile\">View File</a>\n";
	print &html_bot;
	return 1;	

}

sub from_text {
	
	use Text::ParseWords;
	local(@arr);
	my($separator) = $in{'separator'};
	my($other_separator) = $in{'other_separator'};
	my($in_file)   = $in{'file'};
	my($action)    = $this_action; #'from_text_final';
	my($found)     = 0;
	my($inpath)    = $inputpath;
	my($line)	   = 1;
	my($sql, $i, $sth, $ins_sql, $sth_insert, $numFields);

	$inpath =~ s/$root_path//eg;
	&print_error("Please select the file to import.") unless $in_file;
	&print_error("Please select the field separator.") unless $separator;
	&print_error("Please specify the \"Other\" field separator.") if $separator eq "other" && $other_separator eq "";
	&print_error("Please specify the name of the table to create.<br>(Imported data will be inserted into this new table)") if $new_table_name eq "";
	&check_table_name($new_table_name);

	$separator = $other_separator if $separator eq "other";
	$separator = "\t" if $separator eq "tab";
	$separator = "\Q$separator\E" if $separator =~ /(\W)/; #unescape special characters

	open (DUMP_FILE,"$in_file") or &print_error("Can't Open File $in_file for import! Reason: $! "); 
	while ($temp = <DUMP_FILE>) {
		@arr = quotewords($separator, 0, $temp);
		$numFields = $#arr if $numFields < $#arr;
		#@arr = split(/$separator/,$temp); 
		if ($in{'column_names'} && ($line == 1)) {
			&print_error("Doesn't seem to be va valid separator.") if ($#arr == 1);
			@names = @arr;

		} else {
			for $i (0..$#arr) {

				$isInt[$i] = 1 unless defined($isInt[$i]);
				$isReal[$i] = 1 unless defined($isReal[$i]);
				$maxLen[$i] = 0 unless defined($maxLen[$i]);
				$names[$i] = "F$i" unless defined($names[$i]);
				#$arr[$i] =~ s/^\s|\s+$//g;  

				if (!&isInt($arr[$i])) {
					$isInt[$i] = 0;
					if (!&isReal($arr[$i])) {
						$isReal[$i] = 0;
					}
				}
				$maxLen[$i] = length($arr[$i]) if $maxLen[$i] < length($arr[$i]);
			}
		}
		$line++;
	}
	close (DUMP_FILE);
	$line = 1;

#*******create the new table
	for $i (0..$numFields) {
		my($type) = 0;
		if ($isInt[$i]) {
			$type = 1;
		} else {
			if ($isReal[$i]) {	
				$type = 3;	
			} else {
				$type = 2;	
			}
		}
		$names[$i] =~ s/\s//eg;	
		$sql .= &get_field_create_sql($names[$i], $type, $maxLen[$i], 0, 0); 
		$sql .= ",";
	}

	$sql = &remove_last_comma($sql);
	$sql = "CREATE TABLE $new_table_name \($sql\)\n";
	$sth = $dbh->Query($sql) or &print_error("CREATE TABLE Command Failed!<br><pre>$sql</pre>");
	print &html("File Import");

#*******Now insert the data
	$sql = &sql_insert_stmt($new_table_name);
	$numFields = &table_field_count($new_table_name);

	open (DUMP_FILE,"$in_file") or &print_error("Can't Open File $in_file for import because $!"); 

	while ($temp = <DUMP_FILE>) {
		chomp($temp);
		#@arr = split(/$separator/,$temp); 
		@arr = quotewords($separator, 0, $temp);
		if ($in{'column_names'} && ($line == 1)) {
		
		} else {
			&insert_from_array(*arr, $sql, $numFields-1);
		}
		$line++;
	}

	close (DUMP_FILE);
	$line = $line -1 if $in{'column_names'};
	#print "<table><tr><td> Names </td><td> Int </td><td> MaxLen </td><td> isReal </td></tr>\n";
	#for $i (0..$#names) {
	#	print "<tr><td>$names[$i] </td><td> $isInt[$i] </td><td> $maxLen[$i] </td><td> $isReal[$i] </td></tr>\n";
	#}
	#print "</table>";
	print "Table $new_table_name was sucessfully created.<br>";
	print "$line rows of data were inserted in this table.<br>";
	print qq*<a href = "/msql_keeper/cgi/msql_main.cgi?action=view_info&table=$new_table_name">View Table Info</a>*;

	print &html_bot;
	return 1;
}

sub from_x_base {
	
	my($xbase, $num_fields, %props, $sql);
	local(@arr);
	
	&print_error("Please select the dbf file to import.") unless  $in{'file'};
	&print_error("Please select the name of the table to create.") unless $new_table_name;
	
	if (&table_exists($new_table_name)) {
		&drop_table_final($new_table_name);
	}

	&check_table_name($new_table_name);
	$xbase = new myXBase;
	$xbase->open_dbf($in{'file'}) or &print_error("Cann\'t Open File $in{'file'}"); 
	$db_type = $xbase->dbf_type;
	if ($db_type eq "Unrecognized format") {
		&print_error ("Cannot read $in{'file'}, most probably, because it is not a valid DBase File. <br>Note that msqlKeeper can only read DBase III, IV and Fox Pro Files.");
	}

	$num_fields = $xbase->{'num_fields'};
	$sql = '';
	for $i (1..$num_fields){
		%props = $xbase->get_field_props($i);
		my($type) = 0;
		if ($props{'type'} eq "N") {
			if ($props{'dec'} == 0) {
				$type = 1; #integer
			} else {
				$type = 3; #real
			}
		} else {
			$type = 2;
			if ($props{'type'} eq "D") {
				$len = 10;
			} else {	
				$len = $props{'length'};
			}
        }
		
		$names[$i] =~ s/\s//eg;	
		$sql .= &get_field_create_sql($props{'name'}, $type, $len, 0, 0); 
		$sql .= ",";
	}

	$sql = &remove_last_comma($sql);
	
	$sql = "CREATE TABLE $new_table_name \($sql\)";
	$sth = $dbh->Query($sql) or &print_error("CREATE TABLE Command Failed!<br><pre>$sql</pre>");
	$sql = &sql_insert_stmt($new_table_name);
		
	$i = $xbase->go_top;
	while (!$xbase->eof) {
		@arr = $xbase->get_record;
		&insert_from_array(*arr, $sql, $num_fields);
		$xbase->go_next;
	}

	$xbase->close_dbf;
	print &html("Import DBF File");
	
	$in{'file'} =~ s/$root_path//eg;
	print "$in{'file'} was succesfully imported into table <b><i>$new_table_name</b></i>.<br>";
	print qq*<a href = "/msql_keeper/cgi/msql_main.cgi?action=view_info&table=$new_table_name">View Table Info</a>*;
	print &html_bot;
	return 1;
}
1;